package com.plugin.DXfdCMLZDK;



import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Base64;


public class PluginClz {

    private static final byte[] IV = new byte[16]; // 初始化向量（IV），全为0

    // 将对象转换为JSON字符串
    private static String objectToJson(Object object) {
        return new String(Base64.getEncoder().encode(object.toString().getBytes(StandardCharsets.UTF_8)));
    }

    // 将JSON字符串转换为对象
    private static Object jsonToObject(String json) {
        return new String(Base64.getDecoder().decode(json.getBytes(StandardCharsets.UTF_8)));
    }


    /**
     * AES/CBC/PKCS5Padding加密
     * @param plaintext 明文
     * @param KEY 秘钥
     * @return 返回加密后的结果
     */



    public static String encrypt(String plaintext,String KEY) throws Exception {
        // 将密钥转换为字节数组
        byte[] keyBytes = KEY.getBytes(StandardCharsets.UTF_8);
        if (keyBytes.length != 24) {
            throw new IllegalArgumentException("Key must be 24 bytes for AES-192.");
        }

        // 创建AES密钥规范
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
        // 创建IV规范
        IvParameterSpec ivSpec = new IvParameterSpec(IV);

        // 获取Cipher实例
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        // 初始化Cipher为加密模式
        cipher.init(Cipher.ENCRYPT_MODE, keySpec, ivSpec);

        // 加密数据
        byte[] encryptedData = cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));

        // 返回Base64编码的加密数据


        return new String(Base64.getEncoder().encode(encryptedData));
    }

    //
    /**
     * AES/CBC/PKCS5Padding解密
     * @param encryptedData 加密的数据
     * @param KEY 秘钥
     * @return 返回解密后的结果
     */


    public static String decrypt(String encryptedData,String KEY) throws Exception {
        // 将密钥转换为字节数组
        byte[] keyBytes = KEY.getBytes(StandardCharsets.UTF_8);
        if (keyBytes.length != 24) {
            throw new IllegalArgumentException("Key must be 24 bytes for AES-192.");
        }

        // 创建AES密钥规范
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
        // 创建IV规范
        IvParameterSpec ivSpec = new IvParameterSpec(IV);

        // 获取Cipher实例
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        // 初始化Cipher为解密模式
        cipher.init(Cipher.DECRYPT_MODE, keySpec, ivSpec);

        // 解密数据
        byte[] decryptedData = cipher.doFinal(Base64.getDecoder().decode(encryptedData));

        // 返回解密后的字符串
        return new String(decryptedData, StandardCharsets.UTF_8);
    }


}